
#ifndef __USBPRINT_H__
#define __USBPRINT_H__

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned char EnumUsbDevice(void);
unsigned int UsbWriteBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
unsigned int UsbReadBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
unsigned char CheckUsbVidPid(char *DevicePath,int vendorID,int productID);
unsigned char CheckUsbSerialNo(char *DevicePath,char *serialNo);
unsigned char CheckUSBOnline(void);

#define USB_VID 0xC251
#define USB_PID 0x1706
#define USB_DEV_SERIAL_NO  "0002a0000000"
//#define USB_VID 0x067B
//#define USB_PID 0x2303
//#define USB_DEV_SERIAL_NO  "5&186144f5&0&5"

#ifndef MAX_PATH
#define MAX_PATH 260
#endif

typedef struct _USB_DEVICE_INFO {
    unsigned short vid;
    unsigned short pid;
	unsigned short count;
    char SerialNo[256][MAX_PATH];
    char DeviceName[256][MAX_PATH];
} USB_DEVICE_INFO;

extern USB_DEVICE_INFO USBDeviceInfo;
extern unsigned int USBDevIndex;
extern char DeviceName[MAX_PATH];

#ifdef __cplusplus
};
#endif

#endif